@extends('layouts.general')

{{-- @section('title', 'Página de contactos') --}}



@section('main_content')



    {{-- nav --}}
    <section class="page-title" style="background-image: url({{ asset('images/resource/partners/Banner-Partners.png') }})"
        id="about">
        <h1 class="d-none">Our Trusted Partners- ITG Group</h1>
        <div class="auto-container">
            <ul class="bread-crumb clearfix">
                <li><a href="{{ route('home.index') }}">{{ __('messages.home') }} </a></li>
                <li>{{ __('messages.partners') }} </li>
            </ul>
            <h2>{{ __('messages.partners') }} </h2>
        </div>
    </section>


    {{-- PARTNETS --}}
    <section class="service-section-five">
        <div class="auto-container">
            <!-- Sec Title -->
            <div class="sec-title alternate centered">
                <h2 class="text-uppercase">{{ __('messages.partners') }} </h2>
                <h3 class="text-uppercase">{{ __('messages.partner-subtitle') }} </h3>
                {{-- <kdiv class="title text-uppercase">{{ __('messages.partners') }} </kdiv> --}}
            </div>
            <div class="row clearfix d-flex justify-content-center">

                @php
                switch ($division->name) {
                    case 'brasil':
                        $data = $util->partnersBrazil;
                        break;
                    case 'argentina':
                        $data = $util->partnersArgentina;
                        break;
                    case 'mexico':
                        $data = $util->partnersMexico;
                        break;
                    case 'colombia':
                        $data = $util->partnersColombia;
                        break;
                    default:
                        $data = $util->partners;
                        break;
                }
            @endphp
            

                    @foreach ($data as $partner)
                        <div class="p-2 ">
                            <div class="service-block-two">
                                <div class="inner-box">
                                    <div class="image">
                                        <img src="{{ asset($partner->img) }}" alt="Image partner" />
                                        <div class="overlay-box">
                                            <span class="icon d-flex justify-content-center">
                                                <img class="icon-partner" src="{{ asset($partner->icon) }}"
                                                    alt="Icon Partners">
                                            </span>
                                            <div class="content">
                                                <h4 style="font-size: 20px;">{{ $partner->title }} </h4>
                                                <div class="title text-dark">{{ __('messages.partner-' . $partner->id) }}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="overlay-box-two">
                                            {{-- <span class="icon-two flaticon-drop-of-liquid"></span> --}}

                                            <span class="icon-two d-flex justify-content-center">
                                                <img class="icon-partner" src="{{ asset($partner->icon) }}"
                                                    alt="Icon Partners">
                                            </span>
                                            <div class="overlay-inner">
                                                <div class="overlay-content">
                                                    <p class="_h4 color-yellow1"> {{ $partner->title }} </p>
                                                    <div class="text text-light">
                                                        {{ __('messages.partner-text-' . $partner->id) }} </div>
                                                    {{-- <p class="read-more">Read more <span
                                                    class="flaticon-next-3"></span></p> --}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach


            </div>
        </div>
    </section>



    {{-- section How It Work --}}

    <section class="process-section">
        <div class="auto-container">
            <div class="row clearfix">

                <!-- Content Column -->
                <div class="content-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <!-- Sec Title -->
                        <div class="sec-title alternate">
                            <div class="title text-dark">{{ __('messages.partner-title-how-it-work') }} </div>
                            <h2>{{ __('messages.partner-subtitle-how-it-work') }} </h2>
                        </div>
                        <!-- Blocks Outer -->
                        <div class="blocks-outer">

                            <!-- Process Block -->
                            <div class="process-block">
                                <div class="inner-box">
                                    <div class="number">01</div>
                                    <p class="font-part-list">{!! __('messages.partner-list1-how-it-work') !!} </p>
                                    {{-- Lorem ipsum dolor sit amet, consectetur adipisic ing elit, sed do eiusmod tempor --}}
                                </div>
                            </div>

                            <!-- Process Block -->
                            <div class="process-block">
                                <div class="inner-box">
                                    <div class="number">02</div>
                                    <div class="py-4">
                                        <p class="font-part-list">{{ __('messages.partner-list2-how-it-work') }} </p>
                                    </div>
                                    {{-- Lorem ipsum dolor sit amet, consectetur adipisic ing elit, sed do eiusmod tempor
                                    incididunt --}}
                                </div>
                            </div>

                            <!-- Process Block -->
                            <div class="process-block">
                                <div class="inner-box">
                                    <div class="number">03</div>
                                    <div class="py-3">
                                        <p class="font-part-list">{{ __('messages.partner-list3-how-it-work') }} </p>
                                    </div>
                                </div>
                            </div>

                            <div class="upper-column info-box d-inline px-2">
                                <div class="outer-box p-0">
                                    <a class="btn-web-catalog text-capitalize c-main"
                                        href="{{route('contact.index')}}#contactform">{{ __('messages.contacts-us') }} </span></a>
                                </div>
                            </div>

                        </div>
                        <!-- End Blocks Outer -->
                    </div>
                </div>

                <!-- Images Column -->
                <div class="images-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <div class="image wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <img src="{{ asset('/images/resource/partners/Rectangle 178.png') }}" alt="" />
                        </div>
                        <div class="image wow fadeInUp p-3" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <img src="{{ asset('images/resource/partners/Rectangle 180.png') }}" alt="" />
                        </div>
                        <div class="image-two wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <img src="{{ asset('images/resource/partners/Rectangle 179.png') }}" alt="" />
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    {{-- CAROUSEL --}}
    {{-- <section class="testimonial-section-three" style="background-image:url(images/background/map.png)">
        <div class="auto-container">
            <!-- Sec Title -->
            <div class="sec-title alternate centered">
                <div class="title text-dark">{{ __('messages.partner-title-testimonial') }} </div>
                <h2>{{ __('messages.partner-subtitle-testimonial') }} </h2>
            </div>
            <div class="three-item-carousel-two owl-carousel owl-theme">


                @for ($i = 0; $i < 5; $i++)
                    <!-- Testimonial Block Two -->
                    <div class="testimonial-block-two">
                        <div class="inner-box">
                            <div class="author-box bg-dark">
                                <div class="author-inner">
                                    <div class="author-image">
                                        <img src="images/resource/author-6.jpg" alt="" />
                                    </div>
                                    <strong class="color-blue1 ">Jeffery Marshall</strong>
                                    <div class="designation color-blue1 ">Founder & Ceo</div>
                                </div>
                            </div>
                            <div class="text text-dark">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
                                eiusmod tempor
                                incididunt ut labore et dolore Risus facilisis.</div>
                            <div class="rating">
                                <span class="fa fa-star"></span>
                                <span class="fa fa-star"></span>
                                <span class="fa fa-star"></span>
                                <span class="fa fa-star"></span>
                                <span class="fa fa-star"></span>
                            </div>
                        </div>
                    </div>
                @endfor

            </div>
        </div>

    </section> --}}




@endsection

@push('styles')
    <style>
        .icon-partner {
            object-fit: contain;
            margin: auto;
            width: 79px !important;
            height: 70px !important;
        }

        .font-part-list {
            font-size: var(--font-20);
        }

        .process-block .inner-box .number {
            -webkit-text-fill-color: var(--color-green-one);
            -webkit-text-stroke-width: 0px;
            -webkit-text-stroke-color: 0px;
            font-size: var(--font-50);
        }

        .process-block .inner-box strong {
            font-size: var(--font-20);
            color: var(--color-r-black);
        }

        .testimonial-block-two .inner-box .rating .fa {
            color: var(--main-color);
        }

        .service-block-two .inner-box .overlay-box-two:before {

            background-color: var(--color-r-black);
        }

        .service-block-two .inner-box .overlay-box-two .read-more {
            background-color: var(--color-jet-stream);
            color: var(--main-color)
        }

        .service-block-two .inner-box .overlay-box .content {
            background: var(--color-background1);
        }

        .service-block-two .inner-box .overlay-box .icon {
            background: var(--color-green-one);
        }

        .service-block-two .inner-box .overlay-box-two .icon-two {
            background: var(--color-green-one);
        }

        .c-main {
            color: var(--main-color);
        }
    </style>
@endpush
