<div>
    <div class="auto-container">
        <!-- Contact Form -->
        <div class="contact-form">
            @if (session('messageSuccess'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>{{ session('messageSuccess') }} </strong>
                    <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @elseif (session('error_message'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <strong>{{ session('error_message') }} </strong>
                    <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif
            <div wire:loading.flex style="display: none">
                <div class="cont-loader">
                    <div class="loader"></div>
                </div>
            </div>

            <!-- Contact Form -->
            <form wire:submit.prevent="store" novalidate="novalidate">
                <div class="row clearfix">
                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                        <input type="text" wire:model="username" placeholder="{{ __('messages.name') }}*">
                        @error('username')
                            <div class="alert alert-danger my-2 rounded-lg">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                        <input type="text" wire:model="company" placeholder="{{ __('messages.company') }}*">
                        @error('company')
                            <div class="alert alert-danger my-2 rounded-lg">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                        <input type="text" wire:model="country" placeholder="{{ __('messages.country') }}*">
                        @error('country')
                            <div class="alert alert-danger my-2 rounded-lg">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                        <input type="email" wire:model="email" placeholder="{{ __('messages.email') }}*">
                        @error('email')
                            <div class="alert alert-danger my-2 rounded-lg">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                        <textarea wire:model="messageEmail" placeholder="{{ __('messages.inquiry') }}*"></textarea>
                        @error('messageEmail')
                            <div class="alert alert-danger my-2 rounded-lg">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                        <div class="file-upload-wrapper"
                            data-text="{{ $file ? $file->getClientOriginalName() : __('messages.careers-input6') }}">
                            <input name="file-upload-field" type="file" class="file-upload-field" wire:model="file"
                                id="cv" value="">
                            <span class="upload-text">{{ __('messages.upload') }} </span>
                        </div>
                        @error('file')
                            <div class="alert alert-danger my-2 rounded-lg">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>


                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                        <button class="theme-btn btn-style-eight clearfix" type="submit" wire:loading.attr="disabled">
                            <span class="btn-wrap">
                                <span class="text-one">{{ __('messages.send-message') }} </span>
                                <span class="text-two">{{ __('messages.send-message') }} </span>
                            </span>
                        </button>
                    </div>

                </div>
            </form>
        </div>
        <!--End Contact Form -->
    </div>
</div>
