<div>
    @if (session('messageSuccess'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>{{ session('messageSuccess') }} </strong>
            <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @elseif (session('error_message'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>{{ session('error_message') }} </strong>
            <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div wire:loading.flex style="display: none">
        <div class="cont-loader">
            <div class="loader"></div>
        </div>
    </div>


    <form wire:submit.prevent="store" novalidate="novalidate">

        <div class="form-group">
            <input type="text" wire:model="name" placeholder="{{ __('messages.name') }}">
            @error('name')
                <div class="alert alert-danger my-2 rounded-lg">
                    {{ $message }}
                </div>
            @enderror
        </div>
        <div class="form-group">
            <input type="text" wire:model="country" placeholder="{{ __('messages.country') }}">
            @error('country')
                <div class="alert alert-danger my-2 rounded-lg">
                    {{ $message }}
                </div>
            @enderror
        </div>

        <div class="form-group">
            <input type="email" wire:model="email" placeholder="{{ __('messages.email') }}">
            @error('email')
                <div class="alert alert-danger my-2 rounded-lg">
                    {{ $message }}
                </div>
            @enderror
        </div>

        <div class="form-group">
            <textarea wire:model="messageEmail" placeholder="{{ __('messages.your-question') }}"></textarea> {{-- Your Question Here --}}
            @error('messageEmail')
            <div class="alert alert-danger my-2 rounded-lg">
                {{ $message }}
            </div>
        @enderror
        </div>

        <div class="form-group">
            <button type="submit" class="theme-btn btn-style-one text-white"><span class="txt">{{ __('messages.contact-now') }}
                </span></button>
        </div>
    </form>
</div>
