@extends('layouts.general')

@section('main_content')
    {{-- nav --}}
    <section class="page-title" style="background-image: url({{ asset('images/resource/contacts/BannerContacts.png') }})"
        id="about">
        <h1 class="d-none">Contact us - ITG Group</h1>
        <div class="auto-container">
            <ul class="bread-crumb clearfix">
                <li><a href="#">{{ __('messages.home') }} </a></li>
                <li>{{ __('messages.contacts') }} </li>
            </ul>
            <h2>{{ __('messages.contacts') }} </h2>
        </div>
    </section>

    {{-- office  near yor  --}}
    @if ($division->id == 1)
        <section class="contact-page-section">
            <div class="auto-container">
                <!-- Sec Title Three -->
                <div class="sec-title-three centered">
                    <h2>{{ __('messages.contact-title') }} </h2>
                </div>

                <div class="row clearfix">

                    <!-- Location Block -->
                    <div class="location-block col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="content">
                                <img class="icon" src="{{ asset('images/resource/contacts/Icono Email.png') }}"
                                    alt="Icon Email">
                                <strong>{{ __('messages.contact-title-carad1') }} </strong>
                                {{ __('messages.contact-subtitle-carad1') }}
                            </div>
                            {!! __('messages.contact-text-card1') !!}

                        </div>
                    </div>

                    <!-- Location Block -->
                    <div class="location-block col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <a class="color-black1" href="https://wa.me/522223628956" target=”_blank”>
                                <div class="content color-dark">
                                    <img class="icon" src="{{ asset('images/resource/contacts/Icono Numero.png') }}"
                                        alt="Icon Phone">
                                    <strong>{{ __('WhatsApp') }} </strong>
                                    {{ __('messages.contact-subtitle-carad2') }}
                                </div>
                            </a>
                            {{-- {!! __('messages.contact-text-card2') !!} --}}
                        </div>
                    </div>

                    <!-- Location Block -->
                    <div class="location-block col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-box
                        wow fadeInLeft" data-wow-delay="0ms"
                            data-wow-duration="1500ms">
                            <div class="content">
                                <img class="icon" src="{{ asset('images/resource/contacts/Icono Direccion.png') }}"
                                    alt="Icon Address">
                                <strong>{{ __('messages.contact-title-carad3') }} </strong>
                                {{ __('messages.contact-subtitle-carad3') }}
                            </div>
                            {!! __('messages.contact-text-card3') !!}
                        </div>
                    </div>

                </div>

            </div>
        </section>
    @endif
    {{-- DIVISIONS --}}
    <section class="service-section-five">
        <div class="auto-container">
            <!-- Sec Title -->
            <div class="sec-title alternate centered">
                @if ($division->id == 1)
                    <h2 class="">{{ __('messages.contact-title-choose') }} </h2>
                @else
                    <h2 class="text-uppercase">{{ __('messages.contacts') }} </h2>
                    <h3 class="">{{ __('messages.contact-subtitle-contacts') }} </h3>
                @endif
            </div>
            <div class="row clearfix">
                <div class="sec-title alternate my-5 text-left">
                    <h3 class="color-green3 text-uppercase">{{ __('messages.contact-itg-worldwide') }} </h4>
                </div>
                @foreach ($util->contactDivisions->chunk(ceil($util->contactDivisions->count() / 2)) as $div)
                    <div class="card-chain mt-3 text-center">
                        <div class="card-connector inner-box wow fadeInLeft" data-wow-delay="0ms"
                            data-wow-duration="1500ms">
                        </div>
                        <div class="card-deck">
                            @foreach ($div as $item => $divisions)
                                <button type="button" data-toggle="modal" data-target="#DivisionModal"
                                    onclick="showCountryDetailsDivision ('{{ e($item) }}')"
                                    class="card container-card inner-box wow fadeInLeft card-division-check">
                                    <div class="circular-card" style="background-image: url('{{ $divisions->img }}')">
                                        <div class="card-body">
                                        </div>
                                    </div>
                                    <div>
                                        <div>
                                            <p class="color-green1 font-weight-bold  h5 m-0">
                                                {{ __('nationality.' . $divisions->id . '-division') }}</p>
                                            @isset($divisions->text)
                                                <p class="font-italic">{{ __('nationality.' . $divisions->id . '-text') }} </p>
                                            @endisset
                                        </div>
                                    </div>
                                </button>



                                {{-- <x-card-contact img="{{ $divisions->img }}">
                                    <button type="button" class="btn btn-link text-black" data-toggle="modal"
                                        data-target="#DivisionModal"
                                        onclick="showCountryDetailsDivision ('{{ e($item) }}')">
                                        <div>
                                            <p class="color-green1 font-weight-bold  h5 m-0">
                                                {{ __('nationality.' . $divisions->id . '-division') }}</p>
                                            @isset($divisions->text)
                                                <p class="font-italic">{{ __('nationality.' . $divisions->id . '-text') }} </p>
                                            @endisset
                                        </div>
                                    </button>
                                </x-card-contact> --}}
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
    {{-- AGENTS --}}
    <section class="service-section-five">
        <div class="auto-container">
            <div class="row clearfix">
                <div class="sec-title alternate my-5 text-left">
                    <h3 class="color-green3 text-uppercase">{{ __('messages.contact-itg-worldwide') }} </h4>
                </div>
                {{-- section 1 --}}
                <div class="card-chain mt-3 text-center">
                    <div class="card-connector inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                    </div>
                    <div class="card-deck">
                        @foreach ($util->continents as $item => $continent)
                            <x-card-contact img="{{ $continent->img }}">
                                <div class="">
                                    <a class="color-green1 font-weight-bold m-0 collapsed d-flex align-items-center text-center justify-content-center"
                                        type="button" data-toggle="collapse" data-target="#collapse{{ $continent->id }}"
                                        aria-expanded="true" aria-controls="collapseOne">
                                        <p class="color-green1 h5">
                                            {{ __('messages.contacty-agent-title' . $continent->id) }}
                                        </p>
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                            class="icon icon-tabler icon-tabler-chevron-right" width="25" height="44"
                                            viewBox="0 0 24 24" stroke-width="1.5" stroke="#014023" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path d="M9 6l6 6l-6 6" />
                                        </svg>
                                    </a>
                                    <div id="collapse{{ $continent->id }}" class="collapse" aria-labelledby="headingOne"
                                        data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul id="country-list" class="list-group">
                                                @foreach (trans('countries.countries.' . $item) as $index => $country)
                                                    @if (is_array($country) && isset($country[0]) && is_array($country[0]))
                                                        {{-- Si es un array de arrays, usaremos solo el primer país --}}
                                                        @php
                                                            $country = $country[0];
                                                        @endphp
                                                    @endif
                                                    <li
                                                        class="list-group-item d-flex justify-content-between align-items-center border-0">
                                                        <button type="button" class="btn btn-link text-black"
                                                            style="color: black; text-decoration: none;"
                                                            data-toggle="modal" data-target="#contriesModal"
                                                            onclick="showCountryDetails('{{ e($item) }}', {{ $index }})">
                                                            {{ $country['country'] }}

                                                        </button>
                                                    </li>
                                                @endforeach



                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            </x-card-contact>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    @if ($division->id == 1)
        {{-- section How It Work --}}
        <section class="process-section bg-r-black">
            <div class="auto-container">
                <div class="row clearfix">
                    <!-- Content Column -->
                    <div class="content-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <!-- Sec Title -->
                            <div class="sec-title alternate">
                                <div class="title text-light">{{ __('messages.contact-title-how-it-work') }} </div>
                                <h2 class="color-yellow1">{{ __('messages.contact-subtitel-how-it-work') }} </h2>
                            </div>
                            <!-- Blocks Outer -->
                            <div class="blocks-outer">
                                <!-- Process Block -->
                                <div class="process-block">
                                    <div class="inner-box">
                                        <div class="number">01</div>
                                        <p class="text-light font-part-list">{!! __('messages.partner-list1-how-it-work') !!}
                                        </p>
                                    </div>
                                </div>
                                <!-- Process Block -->
                                <div class="process-block">
                                    <div class="inner-box">
                                        <div class="number">02</div>
                                        <p class="text-light font-part-list">
                                            {{ __('messages.partner-list2-how-it-work') }}
                                        </p>
                                    </div>
                                </div>
                                <!-- Process Block -->
                                <div class="process-block">
                                    <div class="inner-box">
                                        <div class="number">03</div>
                                        <p class="text-light font-part-list">
                                            {{ __('messages.contact-list-title3-how-it-work') }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <!-- End Blocks Outer -->
                        </div>
                    </div>
                    <!-- Images Column -->
                    <div class="images-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <img class="w-100" src="{{ asset('images/resource/contacts/Rectangle 179.png') }}"
                                alt="Agents network" />
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif


    {{-- form section careers --}}
    <section class="process-section" id="contactform">
        <div class="auto-container">
            <div class="sec-title-three centered">
                <h2 class="text-uppercase">{{ __('messages.careers-subtitle') }}</h2>
                <p class="my-5">{{ __('messages.careers-text') }} </p>
            </div>
            <div class="comment-form">
                @livewire('contact-request-post', ['dataDivision' => $division])
            </div>
        </div>
    </section>



    <!-- Modal -->
    <div class="modal fade" id="contriesModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-green3 ">
                    <h5 class="modal-title text-white" id="exampleModalLabel">{{ __('messages.contact-details') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="modal-body">

                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="DivisionModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-green3 ">
                    <h5 class="modal-title text-white" id="exampleModalLabel">{{ __('messages.contact-details') }} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="modal-body2">
                        <p><strong>{{ __('messages.email') }}:</strong> <span id="DivisionMail"></span></p>
                        <p><strong>{{ __('messages.address') }}:</strong> <span id="DivisionDirection"></span></p>
                        <p><strong>{{ __('messages.phone') }}:</strong> <span id="DivisionPhone"></span></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('styles')
    <style>
        .font-part-list {
            font-size: var(--font-20);
        }

        .process-block .inner-box strong {
            color: var(--white-color);
        }

        .process-block .inner-box .number {
            color: var(--color-green-one);
            -webkit-text-stroke-width: 3px;
            font-size: var(--font-45);
        }

        .collapse-content {
            transition: height 0.3s ease-out;
            overflow: hidden;
        }

        .service-section-five {
            padding: 100px 0px 0px;
            opacity: 0;
            animation: fade-in 1s ease-in-out forwards;
            animation-delay: 1s;
        }

        @keyframes fade-in {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        .card-chain {
            width: 100%;
            position: relative;
            display: inline-block;
            text-align: center;
        }

        .card-connector {
            position: relative;
            top: 127px;
            left: 0;
            width: 100%;
            height: 3px;
            background-color: var(--color-green-one);
            z-index: -1;
        }

        .card-deck {
            display: flex;
            justify-content: space-between;
            flex-wrap: wrap;
            margin-top: 20px;
        }

        .circular-card {
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            width: 100%;
            height: 200px;
        }

        .container-card {
            max-width: 200px;
            overflow: hidden;
            flex: 0 1 calc(50% - 20px);
            margin-bottom: 20px;
            position: relative;
            z-index: 1;
        }

        .card {
            margin-right: 15px;
            background-color: var(--color-background-body) !important;
        }

        .list-group-item {
            background-color: var(--color-background-body) !important;
        }

        .card-deck .card {
            max-width: 200px;
            border: none;
        }

        @media screen and (max-width: 675px) {
            .card-deck .card {
                margin-top: 10px;
            }

            .container-card {
                flex: 0 1 calc(50% - 20px) !important;
                max-width: calc(100% - 20px) !important;
            }

            .card-connector {
                display: none !important;
            }

            .card-deck {
                flex-direction: row !important;
            }
        }
    </style>
@endpush




@push('scripts')
    {{-- ajax --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
    <script>
        $("form").on("change", ".file-upload-field", function() {
            $(this).parent(".file-upload-wrapper").attr("data-text", $(this).val().replace(/.*(\/|\\)/, ''));
        });
    </script>




    <script>
        const locale = "{{ session('locale', 'es') }}";

        console.log(locale);


        // JavaScript para mostrar los detalles del país en el modal
        const divisions = @json(trans('divisions.divisions'));
        const countries = @json(trans('countries.countries'));

        function showCountryDetails(item, index) {
            // Obtener los detalles del país desde el objeto global `countries`
            const countryDetails = countries[item][index];

            // Limpiar el contenido previo
            const countryModalBody = document.querySelector('.modal-body');
            countryModalBody.innerHTML = '';

            // Función para añadir detalles del país al contenido del modal
            function appendCountryDetails(country) {
                const countryEntry = `
            <div class="country-entry">
                <p><strong> {{ __('messages.company') }} :</strong> <span>${country.company}</span></p>
                <p><strong>{{ __('messages.country') }}:</strong> <span>${country.country}</span></p>
                <p><strong>{{ __('messages.email') }}:</strong> <span>${country.email}</span></p>
                <p><strong>{{ __('messages.address') }}:</strong> <span>${country.address}</span></p>
                ${country.phone ? `<p><strong>{{ __('messages.phone') }}:</strong> <span>${country.phone}</span></p>` : ''}
                <br/>
                <hr/>
            </div>
            `;
                countryModalBody.innerHTML += countryEntry;
            }

            // Verificar si `countryDetails` es un arreglo de arreglos
            if (Array.isArray(countryDetails)) {
                countryDetails.forEach(entry => {
                    if (Array.isArray(entry)) {
                        // Si es un arreglo de objetos, iterar sobre cada sub-objeto
                        entry.forEach(subEntry => appendCountryDetails(subEntry));
                    } else {
                        // Si es un objeto, añadirlo directamente
                        appendCountryDetails(entry);
                    }
                });
            } else {
                // Si `countryDetails` es un objeto único
                appendCountryDetails(countryDetails);
            }
        }


        function appendCountryDetails(country) {
            // Crear nodos HTML para cada campo
            const companyNode = document.createElement('p');
            const nameNode = document.createElement('p');
            const emailNode = document.createElement('p');
            const addressNode = document.createElement('p');
            const phoneNode = document.createElement('p');

            // Asignar contenido a los nodos
            companyNode.innerText = country.company ?? '';
            nameNode.innerText = country.country ?? '';
            emailNode.innerText = country.email ?? '';
            addressNode.innerText = country.address ?? '';
            phoneNode.innerText = country.phone ?? '';

            // Añadir nodos al DOM
            document.getElementById('countryCompany').appendChild(companyNode);
            document.getElementById('countryName').appendChild(nameNode);
            document.getElementById('countryEmail').appendChild(emailNode);
            document.getElementById('countryAddress').appendChild(addressNode);
            document.getElementById('countryPhone').appendChild(phoneNode);
        }

        function showCountryDetailsDivision(item) {
            // Obtener los detalles de la división desde el objeto global `divisions`
            const divisionDetails = divisions[item];
            console.log(divisionDetails);

            // Limpiar el contenido previo
            const divisionModalBody = document.querySelector('.modal-body2');
            divisionModalBody.innerHTML = '';

            // Función para añadir detalles de la división al contenido del modal
            function appendDivisionDetails(division) {
                const divisionEntry = `
            <div class="division-entry">
                <p><strong>{{ __('messages.email') }} :</strong> <span>${division.mail}</span></p>
                <p><strong>{{ __('messages.address') }} :</strong> <span>${division.direccion}</span></p>
                <p><strong>{{ __('messages.phone') }} :</strong> <span>${division.telefono ?? ''}</span></p>
                ${division.url ?  `<p><strong>URL:</strong> <a href="${division.url ?? ''}"> ${division.url ?? ''}</a></p>` : ''}
                <br/>
            </div>
        `;
                divisionModalBody.innerHTML += divisionEntry;
            }

            // Verificar si `divisionDetails` es un arreglo de arreglos
            if (Array.isArray(divisionDetails)) {
                divisionDetails.forEach(entry => {
                    if (Array.isArray(entry)) {
                        // Si es un arreglo de objetos, iterar sobre cada sub-objeto
                        entry.forEach(subEntry => appendDivisionDetails(subEntry));
                    } else {
                        // Si es un objeto, añadirlo directamente
                        appendDivisionDetails(entry);
                    }
                });
            } else {
                // Si `divisionDetails` es un objeto único (en caso de que la estructura cambie)
                appendDivisionDetails(divisionDetails);
            }
        }

















        // function showCountryDetailsDivision(item) {
        //     const division = divisions[item][0];


        //     document.getElementById('DivisionMail').innerText = division.mail;
        //     document.getElementById('DivisionDirection').innerText = division.direccion;
        //     document.getElementById('DivisionPhone').innerText = division.telefono ?? '';
        // }
    </script>
@endpush
