@extends('layouts.general')

@section('main_content')
    {{-- nav --}}
    <section class="page-title" style="background-image:url({{ asset('images/blogs/Header-Blog.png') }})" id="about">
        <div class="auto-container">
            <h1 class="d-none"> Welcome to Our Blog- ITG Group</h1>
            <ul class="bread-crumb clearfix">
                <li><a href="{{ route('home.index') }}">{{ __('messages.home') }} </a></li>
                <li>{{ __('messages.blog') }} </li>
            </ul>
            <h2>{{ __('messages.blog') }} </h2>
        </div>
    </section>

    <div class="sidebar-page-container">
        {{-- <div class="pattern-layer" style="background-image:url({{ asset('images/background/pattern-9.png') }})"></div> --}}
        <div class="auto-container">
            <div class="row clearfix">
                <!-- Content Side -->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <div class="blog-classic">

                        @forelse ($blogs as $blog)
                            <!-- News Block Four -->
                            <div class="news-block-four">
                                <div class="inner-box">
                                    <div class="image">
                                        <a href="{{ route('blog.show', $blog) }} "><img
                                                src="{{ asset('images/blogs/' . $blog->image->image_large) }} "
                                                alt="" /></a>
                                    </div>
                                    <div class="lower-content">
                                        <ul class="post-info">
                                            <li>{{ $blog->blogCategory->translation->name }} </li>
                                            <li><span
                                                    class="icon flaticon-calendar"></span>{{ $blog->created_at->format('M d, Y') }}
                                            </li>
                                            <li><span class="icon flaticon-user-2"></span>{{ $blog->views }} </li>
                                        </ul>
                                        <h3><a href="{{ route('blog.show', $blog) }}">{{ $blog->translation->name }}
                                            </a></h3>

                                        <div class="container text">
                                            <div class="news-detail">
                                                <div class="inner-box">
                                            <div class="text-truncate-multiline text-justify">
                                                {!! $blog->translation->description !!}
                                            </div>
                                            </div>
                                        </div>
                                        </div>
                                        <a class="explore"
                                            href="{{ route('blog.show', $blog) }} ">{{ __('messages.btn-card1') }}
                                            <span class="flaticon-plus"></span></a>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <p class="text-center">{{ __('messages.no-blog') }} </p>
                        @endforelse
                        <div class="mt-10">
                            {{ $blogs->links('vendor.pagination.blog') }}
                        </div>
                    </div>
                </div>
                <!-- Sidebar Side -->
                @include('blogs.blog-nav-right')
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        a:not([href]):not([tabindex]) {
            color: var(--color-green-one);
        }

        .text-truncate-multiline {
            display: -webkit-box;
            -webkit-box-orient: vertical;
            overflow: hidden;
            -webkit-line-clamp: 5;
            /* Muestra hasta 3 líneas */
            max-height: calc(1.4em * 5);
            /* Altura máxima basada en el número de líneas */
            line-height: 1.4em;
            /* Altura de línea */
        }
    </style>
@endpush
