<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SpecialtySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all divisions
            DB::table('specialties')->truncate();
        } else {
            //inserting specialty


            #1
            DB::table('specialties')->insert([
                'Id'  => 1,
                'name'  => "Marketing",
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            #2
            DB::table('specialties')->insert([
                'Id'  => 2,
                'name'       => "Administration",
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
