<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProductSectorTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Delete all divisions
            DB::table('product_sector_translations')->truncate();
        } else {
            //inserting specialty

            //? languageS -------------   [1] = Español, [2] 2 = Inglés, [3]  3 = Italiano, [4]  4 = Portugués, [5]   5 = Francés, [6]  6 = Chino ------------------------------

            //inserting specialty
            $sectors = [
                '1' => [
                    'name' => ["ITG Line", "ITG Line", "Linea ITG", "Linha ITG", "Ligne ITG", "ITG 系列"],
                    'description' => [
                        "En ITG Group, estamos comprometidos con la excelencia y procuramos la calidad en cada aspecto de nuestro negocio, incluyendo la selección de proveedores para nuestros repuestos y maquinaria. Como parte integral de nuestros procesos de adquisición, realizamos rigurosas pruebas de calidad para asegurar que los repuestos cumplan con nuestros exigentes estándares de calidad. \n\n Este enfoque nos permite garantizar que los productos que ofrecemos a nuestros clientes en todo el mundo sean de la más alta calidad y fiabilidad. \n\n Además, estamos orgullosos de ofrecer nuestros productos exclusivos de la línea premium ITG. Estos productos no solo cumplen con nuestras estrictas especificaciones técnicas, sino que también superan las expectativas del mercado en términos de rendimiento y durabilidad.",
                        "At ITG Group, we are committed to excellence and procure the quality in every aspect of our business, including the selection of suppliers for our spare parts and machinery. As integral part of our sourcing processes, we conduct rigorous quality testing to ensure that spare parts meet our exacting quality standards. \n\nThis approach allows us to ensure that the products we offer our customers around the world are of the highest quality and reliability \n\nIn addition, we are proud to provide our exclusive ITG Line premium products. These products not only meet our strict technical specifications, but also exceed market expectations in terms of performance and durability. ",
                        "Nel gruppo ITG, ci impegniamo per l'eccellenza e garantiamo la qualità in ogni aspetto del nostro business, inclusa la selezione dei fornitori per i nostri pezzi di ricambio e macchinari. Come parte integrante dei nostri processi di approvvigionamento, conduciamo rigorosi test di qualità per garantire che i pezzi di ricambio soddisfino i nostri severi standard di qualità.\n\nQuesto approccio ci consente di garantire che i prodotti che offriamo ai nostri clienti in tutto il mondo siano della massima qualità e affidabilità.\n\nInoltre, siamo orgogliosi di offrire i nostri prodotti esclusivi della linea premium ITG. Questi prodotti non solo soddisfano le nostre rigorose specifiche tecniche, ma superano anche le aspettative del mercato in termini di prestazioni e durata.",
                        "No Grupo ITG, estamos comprometidos com a excelência e garantimos a qualidade em todos os aspectos do nosso negócio, incluindo a seleção de fornecedores para as nossas peças de reposição e maquinário. Como parte integrante dos nossos processos de aquisição, realizamos rigorosos testes de qualidade para garantir que as peças de reposição atendam aos nossos exigentes padrões de qualidade.\n\nEssa abordagem nos permite garantir que os produtos que oferecemos aos nossos clientes em todo o mundo sejam da mais alta qualidade e confiabilidade.\n\nAlém disso, temos orgulho de oferecer os nossos produtos exclusivos da linha premium ITG. Esses produtos não apenas atendem às nossas rigorosas especificações técnicas, mas também superam as expectativas do mercado em termos de desempenho e durabilidade.",
                        "Chez ITG Group, nous nous engageons à l'excellence et nous veillons à la qualité dans tous les aspects de notre entreprise, y compris la sélection de fournisseurs pour nos pièces détachées et machines. Dans le cadre de nos processus d'approvisionnement, nous effectuons des tests de qualité rigoureux pour nous assurer que les pièces détachées répondent à nos normes de qualité strictes.\n\nCette approche nous permet de garantir que les produits que nous offrons à nos clients dans le monde entier sont de la plus haute qualité et fiabilité.\n\nDe plus, nous sommes fiers de proposer nos produits exclusifs de la ligne premium ITG. Ces produits non seulement respectent nos spécifications techniques strictes, mais dépassent également les attentes du marché en termes de performance et de durabilité.",
                        "在 ITG 集团，我们致力于追求卓越，并确保我们业务各个方面的质量，包括我们备件和机械的供应商选择。作为我们采购流程的重要组成部分，我们进行严格的质量测试，以确保备件符合我们严格的质量标准。\n\n这种方法使我们能够确保我们为全球客户提供的产品具有最高的质量和可靠性。\n\n此外，我们自豪地提供我们独有的 ITG Line 高端产品。这些产品不仅符合我们严格的技术规范，还在性能和耐用性方面超出了市场预期。"
                    ],
                ],
                '2' =>  [
                    'name' => ["Tejido", "Weaving", "Tessitura", "Tecelagem", "Tissage", "编织"],
                    'description' => [
                        "Nuestro negocio tradicional. Suministramos una amplia variedad de repuestos y accesorios para telares de lanzadera, proyectiles, chorro de agua y chorro de aire. La mayoría de nuestros repuestos para esta categoría provienen de nuestra línea ITG.",
                        "Our traditional core business.  We supply a wide variety of spare parts and accessories for rapier, projectile, water-jet and air-jet looms. Most of our spare parts for this category come from our ITG LINE.",
                        "Il nostro business tradizionale. Forniamo una vasta gamma di ricambi e accessori per telai a pinza, proiettile, getto d'acqua e getto d'aria. La maggior parte dei nostri ricambi per questa categoria proviene dalla nostra linea ITG.",
                        "Nosso negócio tradicional. Fornecemos uma ampla variedade de peças de reposição e acessórios para teares de pinça, projétil, jato de água e jato de ar. A maioria das nossas peças de reposição para esta categoria vem da nossa linha ITG.",
                        "Notre activité principale traditionnelle. Nous fournissons une grande variété de pièces de rechange et d'accessoires pour métiers à rapière, projectile, jet d'eau et jet d'air. La plupart de nos pièces de rechange pour cette catégorie proviennent de notre ligne ITG.",
                        "我们的传统核心业务。我们提供各种各样的剑杆、投梭、喷水和喷气织机的备件和配件。我们这一类的大多数备件都来自我们的ITG生产线。"
                    ],
                ],
                '3' =>  [
                    'name' => ["Tejido de punto", "Knitting", "Maglieria", "Malharia", "Tricot", "编织"],
                    'description' => [
                        "Como parte de nuestra oferta de repuestos textiles, ofrecemos un amplio catálogo para el sector de tejido de punto respaldado por la garantía Giamminola y a precios competitivos.",    // Español
                        "As part of our offer of textile spare parts, we offer a wide catalog for the Knitting sector backed by the Giamminola guarantee and at competitive prices.",    // Inglés
                        "Come parte della nostra offerta di ricambi tessili, offriamo un ampio catalogo per il settore della maglieria garantito da Giamminola e a prezzi competitivi.",    // Italiano
                        "Como parte de nossa oferta de peças sobressalentes têxteis, oferecemos um amplo catálogo para o setor de Malharia com a garantia Giamminola e a preços competitivos.",    // Portugués
                        "Dans le cadre de notre offre de pièces de rechange textiles, nous proposons un large catalogue pour le secteur du tricotage avec la garantie Giamminola et à des prix compétitifs.",    // Francés
                        "作为我们纺织备件提供的一部分，我们为针织部门提供由Giamminola保证的广泛目录，并且价格具有竞争力。",    // Chino
                    ],
                ],
                '4' =>  [
                    'name' => ["Trenzado", "Braiding", "Intrecciatura", "Trançadeiras", "Tressage", "编织"],
                    'description' => [
                        "Nuestra línea de negocio de trenzado no solo incluye maquinaria, sino también repuestos y suministros para mantener tu producción en funcionamiento.",    // Español
                        "Our braiding business line not only includes machinery, but also spare parts and supplies to keep your production up and running.",    // Inglés
                        "La nostra linea di business per la trecciatura non include solo macchinari, ma anche ricambi e forniture per mantenere la tua produzione operativa.",    // Italiano
                        "In nossa linha de negócios de trançadeiras não inclui apenas máquinas, mas também peças de reposição e suprimentos para manter sua produção em funcionamento.",    // Portugués
                        "Notre ligne d'activité de tressage inclut non seulement des machines, mais aussi des pièces de rechange et des fournitures pour maintenir votre production en marche.",    // Francés
                        "我们的编织业务线不仅包括机械，还包括备件和供应品，以确保您的生产持续运行。",    // Chino
                    ],
                ],
                // '5' =>  [
                //     'name' => ["Urdido y engomado", "Warping and sizing", "Orditura e incollaggio", "Urdidura e engomagem", "Ourdissage et encollage", "整经和浆纱"],
                //     'description' => [
                //         "Descubre nuestra selección de repuestos para máquinas de urdido y encolado, diseñados para garantizar un rendimiento óptimo y duradero. \nEn ITG Group, nos comprometemos a proporcionarte repuestos de calidad que mantendrán tu equipo en perfecto estado de funcionamiento, asegurando la continuidad de tu producción textil. \n¡Contáctanos hoy mismo para obtener más información y garantizar el rendimiento de tus máquinas con nuestros repuestos confiables y duraderos!",    // Español
                //         "Discover our selection of spare parts for warping and gumming machines, designed to guarantee optimal and long-lasting performance. \nAt ITG Group, we are committed to providing you with quality spare parts that will keep your equipment in perfect working condition, ensuring the continuity of your textile production. \nContact us today for more information and ensure the performance of your machines with our reliable and durable spare parts!",    // Inglés
                //         "Scopri la nostra selezione di ricambi per macchine di orditura e gommatura, progettati per garantire prestazioni ottimali e durature. \nPresso il Gruppo ITG, ci impegniamo a fornirti ricambi di qualità che manterranno il tuo equipaggiamento in perfette condizioni di funzionamento, garantendo la continuità della tua produzione tessile. \nContattaci oggi stesso per maggiori informazioni e assicura il rendimento delle tue macchine con i nostri ricambi affidabili e durevoli!",    // Italiano
                //         "Descubra nossa seleção de peças de reposição para máquinas de urdume e goma, projetadas para garantir desempenho ótimo e duradouro. \nNo Grupo ITG, estamos comprometidos em fornecer peças de reposição de qualidade que manterão seu equipamento em perfeito estado de funcionamento, garantindo a continuidade de sua produção têxtil. \nEntre em contato conosco hoje mesmo para obter mais informações e garantir o desempenho de suas máquinas com nossas peças de reposição confiáveis e duráveis!",    // Portugués
                //         "Découvrez notre sélection de pièces de rechange pour les machines à dresser et à gommer, conçues pour garantir des performances optimales et durables. \nChez ITG Group, nous nous engageons à vous fournir des pièces de rechange de qualité qui maintiendront votre équipement en parfait état de fonctionnement, assurant la continuité de votre production textile. \nContactez-nous dès aujourd'hui pour plus d'informations et assurez le rendement de vos machines avec nos pièces de rechange fiables et durables!",    // Francés
                //         "发现我们为经纬和涂胶机提供的备件选择，旨在保证最佳和持久的性能。 \n在ITG Group，我们致力于为您提供质量可靠的备件，以保持您的设备处于完美的工作状态，确保您的纺织生产的连续性。\n今天立即联系我们获取更多信息，并通过我们可靠耐用的备件确保您的机器的性能！",    // Chino
                //     ],
                // ],
                // '6' =>  [
                //     'name' => ["Teñido y estampado", "Dying and pinting", "Tintura e stampa", "Tingimento e impressão", "Tingimento e impressão", "染色和印花"],
                //     'description' => ['', '', '', '', '', ''],
                // ],
                // '7' =>  [
                //     'name' => ["Etiquetado", "Labeling", "Etichettatura", "Rotulagem", "Étiquetage", "标签"],
                //     'description' => [
                //         "Optimice la producción de sus máquinas de tejido de etiquetas con nuestros repuestos de calidad premium. En ITG Group, ofrecemos una amplia selección de repuestos diseñados específicamente para garantizar un rendimiento óptimo y una producción ininterrumpida. \nDesde piezas de precisión hasta componentes duraderos, tenemos todo lo que necesita para mantener sus telares funcionando al máximo rendimiento.",    // Español
                //         "Optimize the production of your label weaving machines with our premium quality spare parts. At ITG Group, we offer a wide selection of spare parts specifically designed to ensure optimal performance and uninterrupted production. \nFrom precision parts to durable components, we have everything you need to keep your looms running at peak performance.",    // Inglés
                //         "Ottimizza la produzione delle tue macchine per tessere etichette con i nostri ricambi di qualità premium. Presso il Gruppo ITG, offriamo una vasta selezione di ricambi appositamente progettati per garantire prestazioni ottimali e produzione ininterrotta. \nDalle parti di precisione ai componenti durevoli, abbiamo tutto ciò di cui hai bisogno per mantenere i tuoi telai funzionanti al massimo delle prestazioni.",    // Italiano
                //         "Otimize a produção de suas máquinas de tecelagem de etiquetas com nossas peças de reposição de qualidade premium. No Grupo ITG, oferecemos uma ampla seleção de peças de reposição projetadas especificamente para garantir desempenho ótimo e produção ininterrupta. \nDe peças de precisão a componentes duráveis, temos tudo o que você precisa para manter seus teares funcionando com desempenho máximo.",    // Portugués
                //         "Optimisez la production de vos machines à tisser les étiquettes avec nos pièces de rechange de qualité premium. Chez ITG Group, nous proposons une large sélection de pièces de rechange spécialement conçues pour garantir des performances optimales et une production ininterrompue. \nDes pièces de précision aux composants durables, nous avons tout ce dont vous avez besoin pour maintenir vos métiers à tisser en fonctionnement optimal.",    // Francés
                //         "通过我们优质的备件，优化标签织机的生产。 在ITG Group，我们提供了一个广泛的备件选择，专为确保最佳性能和连续生产而设计。 \n从精密部件到耐用组件，我们拥有您保持织机高性能运行所需的一切。",    // Chino
                //     ],
                // ],
                '8' =>  [
                    'name' => ["Hilo", "Yarn", "Filato", "Fios", "Fil", "纱线"],
                    'description' => [
                        "En ITG Group entendemos la importancia del hilo de calidad para la producción textil. Te conectamos con algunos de los principales productores del mundo. Esto nos permite ofrecerte acceso a una amplia variedad de hilos, incluidas opciones como texturizado, poliéster, algodón y muchos más. \n\nNuestro equipo dedicado está aquí para ayudarte a encontrar el hilo adecuado para tus necesidades específicas. Ya sea que estés buscando hilos para tejidos ligeros o materiales más fuertes, podemos ponerte en contacto con los proveedores adecuados que satisfagan tus requisitos de calidad y cantidad. \n\nAdemás de proporcionar acceso a hilos de alta calidad, también nos encargamos de la logística para garantizar una entrega eficiente y oportuna. Desde la gestión de pedidos individuales hasta la coordinación de envíos de contenedores completos, cuidamos cada detalle para que puedas concentrarte en tu producción. \n\nConfía en ITG Group para ser tu socio en la obtención de hilos de calidad y simplificar tus procesos de adquisición; contáctanos hoy mismo para comenzar a explorar nuestras opciones de hilos y descubrir cómo podemos ayudarte a impulsar el éxito de tu negocio textil.",
                        "At ITG Group, we understand the importance of quality yarn for textile production. We connect you with some of the world’s leading producers. This allows us to offer you access to a wide variety of yarns, including options such as texturized, polyester, cotton and many more. \n\nOur dedicated team is here to help you find the right yarn for your specific needs. Whether you are looking for yarns for lightweight fabrics or stronger materials, we can connect you with the right suppliers that meet your quality and quantity requirements. \n\nIn addition to providing access to high-quality yarns, we also handle the logistics to ensure efficient and timely delivery. From managing individual orders to coordinating full container shipments, we take care of every detail so you can focus on your production. \n\nTrust ITG Group to be your partner in sourcing quality yarn and streamlining your procurement processes - contact us today to start exploring our yarn options and find out how we can help you propel your textile business to success.",
                        "Noi di ITG Group, comprendiamo l'importanza della qualità del filato per la produzione tessile. Ti mettiamo in contatto con alcuni dei produttori leader mondiali. Questo ci consente di offrirti accesso a una vasta varietà di filati, tra cui opzioni come testurizzati, poliestere, cotone e molti altri. \n\nIl nostro team dedicato è qui per aiutarti a trovare il filato giusto per le tue esigenze specifiche. Che tu stia cercando filati per tessuti leggeri o materiali più resistenti, possiamo metterti in contatto con i fornitori giusti che soddisfano i tuoi requisiti di qualità e quantità. \n\nOltre a fornire accesso a filati di alta qualità, ci occupiamo anche della logistica per garantire una consegna efficiente e tempestiva. Dalla gestione degli ordini individuali al coordinamento delle spedizioni di container completi, curiamo ogni dettaglio in modo che tu possa concentrarti sulla tua produzione. \n\nAffidati a ITG Group per essere il tuo partner nella ricerca di filati di qualità e nel razionalizzare i tuoi processi di approvvigionamento: contattaci oggi stesso per iniziare a esplorare le nostre opzioni di filato e scoprire come possiamo aiutarti a far decollare la tua azienda tessile verso il successo.",
                        "Na ITG Group, entendemos a importância da qualidade do fio para a produção têxtil. Conectamos você com alguns dos principais produtores do mundo. Isso nos permite oferecer acesso a uma ampla variedade de fios, incluindo opções como texturizados, poliéster, algodão e muito mais. \n\nNossa equipe dedicada está aqui para ajudá-lo a encontrar o fio certo para suas necessidades específicas. Esteja você procurando fios para tecidos leves ou materiais mais resistentes, podemos conectá-lo aos fornecedores certos que atendem aos seus requisitos de qualidade e quantidade. \n\nAlém de fornecer acesso a fios de alta qualidade, também lidamos com a logística para garantir uma entrega eficiente e pontual. Desde a gestão de pedidos individuais até a coordenação de remessas de contêineres completos, cuidamos de cada detalhe para que você possa se concentrar em sua produção. \n\nConfie na ITG Group para ser seu parceiro na busca de fios de qualidade e no aprimoramento de seus processos de aquisição: entre em contato conosco hoje mesmo para começar a explorar nossas opções de fios e descobrir como podemos ajudá-lo a impulsionar seu negócio têxtil para o sucesso.",
                        "Chez ITG Group, nous comprenons l'importance de la qualité du fil pour la production textile. Nous vous mettons en relation avec certains des principaux producteurs mondiaux. Cela nous permet de vous offrir un accès à une grande variété de fils, y compris des options telles que texturés, polyester, coton et bien d'autres. \n\nNotre équipe dévouée est là pour vous aider à trouver le fil adapté à vos besoins spécifiques. Que vous recherchiez des fils pour des tissus légers ou des matériaux plus résistants, nous pouvons vous mettre en relation avec les bons fournisseurs répondant à vos exigences en termes de qualité et de quantité. \n\nEn plus de fournir un accès à des fils de haute qualité, nous gérons également la logistique pour garantir une livraison efficace et ponctuelle. De la gestion des commandes individuelles à la coordination des expéditions de conteneurs complets, nous nous occupons de chaque détail afin que vous puissiez vous concentrer sur votre production. \n\nFaites confiance à ITG Group pour être votre partenaire dans la recherche de fils de qualité et l'optimisation de vos processus d'approvisionnement : contactez-nous dès aujourd'hui pour commencer à explorer nos options de fils et découvrir comment nous pouvons vous aider à propulser votre entreprise textile vers le succès",
                        "在ITG Group，我们了解质量对纺织品生产的重要性。我们将您与全球一些领先的生产商联系起来。这使我们能够为您提供各种各样的纱线，包括诸如聚酯纤维涤纶、棉等多种选择。\n\n我们专注的团队在这里帮助您找到符合您特定需求的合适纱线。无论您是寻找用于轻质面料还是更强大材料的纱线，我们都可以为您联系到符合质量和数量要求的合适供应商。\n\n除了提供高质量的纱线采购外，我们还处理物流以确保高效及及时交付。从管理个别订单到协调整个集装箱的发货，我们关心每一个细节，以便您专注于生产。\n\n相信ITG Group成为您寻找高质量纱线并优化采购流程的合作伙伴：今天就与我们联系，开始探索我们的纱线选择，并了解我们如何帮助您推动纺织业务取得成功。"
                    ],
                ],
                '9' =>  [
                    'name' => ["Accesorios Adicionales", "Additional Accessories", "Accessori Aggiuntivi", " Acessórios Adicionais", "Accessoires Supplémentaires", "附加配件"],
                    'description' => [
                        "Complementa tu producción textil con nuestros accesorios adicionales, como tijeras, linternas, lupas, pistolas de aire, equipos de laboratorio, abrasivos, carros de viga, entre otros.",
                        "Complement your textile production with our additional accessories such as scissors, torchlights, magnifying glass, air gun, laboratory equipment, abrasives, beam trolleys, among others.",
                        "Completa la tua produzione tessile con i nostri accessori aggiuntivi, come forbici, torce, lenti d'ingrandimento, pistole ad aria, attrezzature da laboratorio, abrasivi, carrelli per travi, tra gli altri.",
                        "Complete sua produção têxtil com nossos acessórios adicionais, como tesouras, Carrinho para transporte de rolo de urdume e tecido, lupas, pistolas de ar, equipamentos de laboratório, abrasivos, carrinhos de feixe, entre outros.",
                        "Complétez votre production textile avec nos accessoires supplémentaires tels que des ciseaux, des lampes de poche, des loupes, des pistolets à air, des équipements de laboratoire, des abrasifs, des chariots à poutre, entre autres.",
                        "使用我们的附加配件（如剪刀、手电筒、放大镜、气枪、实验室设备、磨料、梁车等）来补充您的纺织生产。",
                    ],
                ],
            ];

            foreach ($sectors as $key => $sector) {
                foreach ($sector['name'] as $index => $name) {
                    $description = $sector['description'][$index];
                    DB::table('product_sector_translations')->insert([
                        'name'  => $name,
                        'description'  => $description,
                        'language_id'  =>  $index + 1,
                        'product_sector_id'  => $key,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
