<?php

namespace Database\Seeders;

use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class ProductDivisionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all product_category_translations
            DB::table('product_divisions')->truncate();
        } else {
            $faker = Faker::create();
            $products =  DB::table('products')->pluck('id')->toArray();
            $divisions = DB::table('divisions')->pluck('id')->toArray();

            foreach ($products as $product) {
                foreach ($divisions as $division) {
                    DB::table('product_divisions')->insert([
                        // 'id' => $index,
                        'quantity' => $faker->numberBetween(1, 15),
                        'division_id' =>  $division,
                        'product_id' => $product,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
