<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProductCatalogueSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Delete all languages
            DB::table('pdf_sectors')->truncate();
        } else {
            //? languageS -------------   [1] = Español, [2] 2 = Inglés, [3]  3 = Italiano, [4]  4 = Portugués, [5]   5 = Francés, [6]  6 = Chino ------------------------------

            $sectors = [
                'knitting' =>  [
                    'url' => "catalogue/products/Knitting/BR_Knitting-ES.pdf",
                    'product_id' => "3",
                    'language_id' => "1",
                ],
                'knittingEn' =>  [
                    'url' => "catalogue/products/Knitting/BR_Knitting- ENG.pdf",
                    'product_id' => "3",
                    'language_id' => "2",
                ],
                'knittingPort' =>  [
                    'url' => "catalogue/products/Knitting/BR_Knitting-POR.pdf",
                    'product_id' => "3",
                    'language_id' => "4",
                ],

                'braidingEn' =>  [
                    'url' => "catalogue/products/Braiding/BR_Maquinaria-Trenzado-ENG.pdf",
                    'product_id' => "4",
                    'language_id' => "2",
                ],
                'braiding' =>  [
                    'url' => "catalogue/products/Braiding/BR_Maquinaria-Trenzado-ESP.pdf",
                    'product_id' => "4",
                    'language_id' => "1",
                ],
                'braidingPort' =>  [
                    'url' => "catalogue/products/Braiding/BR_Maquinaria-Trenzado-POR.pdf",
                    'product_id' => "4",
                    'language_id' => "4",
                ],


                'yarn' =>  [
                    'url' => "catalogue/products/Yarn/BR_Hilado-ES.pdf",
                    'product_id' => "8",
                    'language_id' => "1",
                ],
                'yarnEn' =>  [
                    'url' => "catalogue/products/Yarn/BR_Hilado-ENG.pdf",
                    'product_id' => "8",
                    'language_id' => "2",
                ],
                'yarnPort' =>  [
                    'url' => "catalogue/products/Yarn/BR_Hilado- POR.pdf",
                    'product_id' => "8",
                    'language_id' => "4",
                ],
            ];


            foreach ($sectors as $sector) {
                DB::table('pdf_sectors')->insert([
                    // 'id' =>  $key,
                    'pdf_catalogue' =>  $sector["url"],
                    'product_sector_id' =>  $sector["product_id"],
                    'language_id' => $sector["language_id"],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
