<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MachineImageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all machine_images
            DB::table('machine_images')->truncate();
        } else {

            // $faker = Faker::create();
            // $images = DB::table('machines')->pluck('id')->toArray();

            $images = [
                [
                    'machine' => 1,
                    'images' =>
                    //water looms
                    [
                        "machinery/weaving/Water-looms/1.png",
                        "machinery/weaving/Water-looms/2.png",
                        "machinery/weaving/Water-looms/3.png",
                        // "machinery/weaving/Water-looms/4.png"
                    ],
                ],
                [
                    'machine' => 2,
                    'images' =>
                    //rapier looms
                    [
                        "machinery/weaving/Rapier-looms/1.png",
                        "machinery/weaving/Rapier-looms/2.png",
                        "machinery/weaving/Rapier-looms/3.png",
                        // "machinery/weaving/Rapier-looms/4.png"
                    ],
                ],
                [
                    'machine' => 3,
                    'images' =>
                    //terry-lomoms
                    [
                        "machinery/weaving/Terry-looms/1.png",
                        "machinery/weaving/Terry-looms/2.png",
                        "machinery/weaving/Terry-looms/3.png",
                        // "machinery/weaving/Terry-looms/4.png"
                    ],
                ],
                [
                    'machine' => 4,
                    'images' =>
                    //air-looms
                    [
                        "machinery/weaving/Air-looms/1.png",
                        "machinery/weaving/Air-looms/2.png",
                        "machinery/weaving/Air-looms/3.png",
                        // "machinery/weaving/Air-looms/4.png"
                    ],
                ],
                [
                    'machine' => 5,
                    'images' =>
                    //Electronic Jacquard
                    [
                        "machinery/braiding/Electronic/Rectangle 169.png",
                        "machinery/braiding/Electronic/Rectangle 168.png",
                        "machinery/braiding/Electronic/Rectangle 167.png",
                    ],
                ],
                [
                    'machine' => 6,
                    'images' =>
                    //sectional
                    [
                        "machinery/warping/Sectional/1.png",
                        "machinery/warping/Sectional/2.png",
                        // "machinery/warping/Sectional/3.png"
                    ],
                ],
                [
                    'machine' => 7,
                    'images' =>
                    [
                        // "machinery/warping/Direct/1.png",
                        "machinery/warping/Direct/2.png",
                        "machinery/warping/Direct/3.png",
                    ],
                ],
                [
                    'machine' => 8,
                    'images' =>
                    [
                        // "machinery/Label/Label-weaving/1.png",
                        "machinery/Label/Label-weaving/2.png",
                        "machinery/Label/Label-weaving/3.png",
                        "machinery/Label/Label-weaving/4.png",
                    ],
                ],
                [
                    'machine' => 9,
                    'images' =>
                    //narrow
                    [
                        // "machinery/Label/Narrow-fabric/1.png",
                        "machinery/Label/Narrow-fabric/2.png",
                        "machinery/Label/Narrow-fabric/3.png",
                        "machinery/Label/Narrow-fabric/4.png",
                    ],
                ],
                [
                    'machine' => 10,
                    'images' =>
                    [
                        // "machinery/Label/High-speed/1.png",
                        "machinery/Label/High-speed/2.png",
                        "machinery/Label/High-speed/3.png",
                    ],
                ],
                [
                    'machine' => 11,
                    'images' =>
                    //high speed automatic
                    [
                        // "machinery/Label/High-speed-automatic/1.png",
                        "machinery/Label/High-speed-automatic/2.png",
                        "machinery/Label/High-speed-automatic/3.png",
                        "machinery/Label/High-speed-automatic/4.png",
                    ],
                ],
                [
                    'machine' => 12,
                    'images' =>
                    //label & folding
                    [
                        // "machinery/Label/Label-folding/1.png",
                        "machinery/Label/Label-folding/2.png",
                        "machinery/Label/Label-folding/3.png",
                    ],
                ],
                [
                    'machine' => 13,
                    'images' =>
                    //ultrasonic
                    [
                        "machinery/Label/Ultrasonic/1.png",
                        "machinery/Label/Ultrasonic/2.png",
                        // "machinery/Label/Ultrasonic/3.png",
                    ],
                ],
                [
                    'machine' => 14,
                    'images' =>
                    //single jersey
                    [
                        "machinery/knitting/Single jersey/1.png",
                        "machinery/knitting/Single jersey/2.png",
                        "machinery/knitting/Single jersey/3.png",
                        // "machinery/knitting/Single jersey/4.png",
                    ],
                ],
                [
                    'machine' => 15,
                    'images' =>
                    //interlock
                    [
                        // "machinery/knitting/InterlockRib/1.png",
                        "machinery/knitting/InterlockRib/2.png",
                        "machinery/knitting/InterlockRib/3.png",
                        "machinery/knitting/InterlockRib/4.png"
                    ],
                ],
                [
                    'machine' => 16,
                    'images' =>
                    //single comouter
                    [
                        "machinery/knitting/Single-computerized/1.png",
                        "machinery/knitting/Single-computerized/2.png",
                        // "machinery/knitting/Single-computerized/3.png",
                        "machinery/knitting/Single-computerized/4.png",
                    ],
                ],
                [
                    'machine' => 17,
                    'images' =>
                    //double coputer
                    [
                        // "machinery/knitting/Double-computerized/1.png",
                        "machinery/knitting/Double-computerized/2.png",
                        "machinery/knitting/Double-computerized/3.png",
                        "machinery/knitting/Double-computerized/4.png",
                    ],
                ],
                [
                    'machine' => 18,
                    'images' =>
                    //scok machine
                    [
                        "machinery/knitting/Sock-Machine/1.png",
                        "machinery/knitting/Sock-Machine/2.png",
                        "machinery/knitting/Sock-Machine/3.png",
                        // "machinery/knitting/Sock-Machine/4.png",
                    ],
                ],
                [
                    'machine' => 19,
                    'images' =>
                    //braiding
                    [
                        // "machinery/braiding/Braiding/1.png",
                        // "machinery/braiding/Braiding/2.png",
                        "machinery/braiding/Braiding/3.png",
                        "machinery/braiding/Braiding/4.png",
                        "machinery/braiding/Braiding/5.png",
                    ],
                ],
                [
                    'machine' => 20,
                    'images' =>
                    //tiping
                    [
                        "machinery/braiding/Tipping/1.png",
                        "machinery/braiding/Tipping/2.png",
                        "machinery/braiding/Tipping/3.png",
                        // "machinery/braiding/Tipping/4.png",
                    ],
                ],
                [
                    'machine' => 21,
                    'images' =>
                    //windig
                    [
                        "machinery/braiding/Winding/1.png",
                        "machinery/braiding/Winding/2.png",
                        // "machinery/braiding/Winding/3.png",
                    ],
                ],
                [
                    'machine' => 22,
                    'images' =>
                    //needle
                    [
                        // "machinery/braiding/Needle/1.png",
                        "machinery/braiding/Needle/2.png",
                        "machinery/braiding/Needle/3.png",
                    ],
                ],
                [
                    'machine' => 23,
                    'images' =>
                    //Singing
                    [
                        "machinery/sizing/Sizing/1.png",
                        "machinery/sizing/Sizing/2.png",
                        "machinery/sizing/Sizing/3.png",
                        // "machinery/sizing/Sizing/4.png",
                    ],
                ],
                [
                    'machine' => 25,
                    'images' =>
                    [
                        // "machinery/Dyeing/Dyeing/Jigger.png",
                        "machinery/Dyeing/Dyeing/Rectangle 167.png",
                        "machinery/Dyeing/Dyeing/Rectangle 168.png",
                        "machinery/Dyeing/Dyeing/Rectangle 169.png"
                    ],
                ],
            ];

            foreach ($images as $machine) {
                $machineId = $machine['machine'];
                foreach ($machine['images'] as $image) {
                    DB::table('machine_images')->insert([
                        // 'id' => $index,
                        'image' => $image,
                        'machine_id' => $machineId,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
