<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
// use Faker\Factory as Faker;

class MachineCategoryTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all machine_category_translations
            DB::table('machine_category_translations')->truncate();
        } else {
            // $faker = Faker::create();
            // $categories = DB::table('machine_categories')->pluck('id')->toArray();
            // $languages = DB::table('languages')->pluck('id')->toArray();
            //? languageS -------------   [1] = Español, [2] 2 = Inglés, [3]  3 = Italiano, [4]  4 = Portugués, [5]   5 = Francés, [6]  6 = Chino ------------------------------




            $categories = [
                '1' => [
                    'name' => ["Tejido", "Weaving", "Tessitura", "Tecelagem", "Tissage",  " 织造"],                ],
                '2' => [
                    'name' => ["Urdido", "Warping","Orditura", "Urdume", "Ourdissage", "整经"],
                ],
                '3' => [
                    'name' => ["Tejido de etiquetas", "Label Weaving", "Etichettatura", "Rotulagem de etiquetas", "Tissage d'étiquettes",  "标签织造"],
                ],
                '4' => [
                    'name' =>  ["Tejido de punto", "Knitting","Maglieria", "Malharia", "Tricotage",  "编织"],
                ],
                '5' => [
                    'name' => ["Trenzado", "Braiding","Intrecciatura", "Trançadeiras", "Tressage",  "编带"],
                ],
                '6' => [
                    'name' =>  ["Engomado", "Sizing", "Incollaggio", "Engomadeira", "Encollage",  "定型"],
                ],
                '7' => [
                    'name' =>  ["Acabado", "Finishing", "Finitura", "Acabamento", "Finition",  "整理"]
                ],
            ];




            foreach ($categories as $key => $category) {
                foreach ($category['name'] as $index => $name) {
                    DB::table('machine_category_translations')->insert([
                        // 'id' => $index,
                        'name' =>$name,
                        'machine_category_id' => $key,
                        'language_id' =>  $index + 1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
