<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class LanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all languages
            DB::table('languages')->truncate();
        } else {
            //inserting lemnguages


            DB::table('languages')->insert([
                'id' =>  1,
                'language' =>  "spanish",
                'flag_image' => "/images/flags/espana-flag.png",
                'language_code' => "es",
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('languages')->insert([
                'id' =>  2,
                'language' =>  "english",
                'flag_image' => "/images/flags/usa-flag.png",
                'language_code' => "en",
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('languages')->insert([
                'id' =>  3,
                'language' =>  "italian",
                'flag_image' => "/images/flags/italia-flag.png",
                'language_code' => "it",
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('languages')->insert([
                'id' =>  4,
                'language' =>  "portuguese",
                'flag_image' => "/images/flags/portugal-flag.png",
                'language_code' => "pt",
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('languages')->insert([
                'id' =>  5,
                'language' =>  "french",
                'flag_image' => "/images/flags/francia-flag.png",
                'language_code' => "fr",
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('languages')->insert([
                'id' =>  6,
                'language' =>  "chinese",
                'flag_image' => "/images/flags/china-flag.png",
                'language_code' => "zh_CN",
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
