<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class DivisionLanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all Divisionlanguages
            DB::table('divisions_languages')->truncate();
        } else {

            //? languageS -------------   1 = Español, 2 = Inglés, 3 = Italiano, 4 = Portugués,  5 = Francés, 6 = Chino ------------------------------
            //? DIVISIONS ------------    1 = main, 2 = mexico, 3 = argentina, 4 = brasil,  5 = colombia, 6 = peru, 7 = italia, 8 = china ------------


            $divisionslanguages = [
                'main'      => [1, 2, 3, 4, 5],
                'mexico'    => [1, 2],
                'argentina' => [1, 2],
                'brasil'    => [4, 2],
                'colombia'  => [1, 2],
                'peru'      => [1, 2],
                'italia'    => [3, 2],
                'china'     => [2, 6]
            ];

            //inserting divisions_languages
            foreach ($divisionslanguages['main'] as $lengauge) {
                #main
                DB::table('divisions_languages')->insert([
                    'division_id' =>  1,
                    'language_id' => $lengauge,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            //inserting divisions_languages
            foreach ($divisionslanguages['mexico'] as $lengauge) {
                #mexico
                DB::table('divisions_languages')->insert([
                    'division_id' => 2,
                    'language_id' => $lengauge,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            //inserting divisions_languages
            foreach ($divisionslanguages['argentina'] as $lengauge) {
                #argentina
                DB::table('divisions_languages')->insert([
                    'division_id' =>  3,
                    'language_id' => $lengauge,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            //inserting divisions_languages
            foreach ($divisionslanguages['brasil'] as $lengauge) {
                #brasil
                DB::table('divisions_languages')->insert([
                    'division_id' =>  4,
                    'language_id' => $lengauge,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            //inserting divisions_languages
            foreach ($divisionslanguages['colombia'] as $lengauge) {
                #colombia
                DB::table('divisions_languages')->insert([
                    'division_id' =>  5,
                    'language_id' => $lengauge,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            //inserting divisions_languages
            foreach ($divisionslanguages['peru'] as $lengauge) {
                #main
                DB::table('divisions_languages')->insert([
                    'division_id' =>  6,
                    'language_id' => $lengauge,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            //inserting divisions_languages
            foreach ($divisionslanguages['italia'] as $lengauge) {
                #main
                DB::table('divisions_languages')->insert([
                    'division_id' => 7,
                    'language_id' => $lengauge,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            //inserting divisions_languages
            foreach ($divisionslanguages['china'] as $lengauge) {
                #main
                DB::table('divisions_languages')->insert([
                    'division_id' =>  8,
                    'language_id' => $lengauge,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
