<?php

namespace Database\Seeders;

use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BlogTagSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all blog_tags
            DB::table('blog_tags')->truncate();
        } else {

            $faker = Faker::create();


                foreach (range(1, 8) as $index) {
                    DB::table('blog_tags')->insert([
                        // 'id' => $index,
                        'name'       => $faker->word,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
        }
    }
}
