<?php

namespace Database\Seeders;

use Faker\Factory as Faker;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BlogSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all blogs
            DB::table('blogs')->truncate();
        } else {

            //? 1 = industry , 2 = innovation

            #Saxonia
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 1,
            //     'name' => Str::slug("ITg brasil saxonia"),
            //     'blog_category_id' => 1,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);

            // #Trenzadoras
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 2,
            //     'name' => Str::slug("Braiding Machines Growths"),
            //     'blog_category_id' => 2,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);

            // #Data, digitalization and technology
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 4,
            //     'name' => Str::slug("Data, digitalization and technology"),
            //     'blog_category_id' => 1,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);

            // #Sustainable is not a TREND, is a NORM!
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 6,
            //     'name' => Str::slug("Sustainable is not a TREND"),
            //     'blog_category_id' => 1,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);
            // #The Digital Product Passport.
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 8,
            //     'name' => Str::slug("The Digital Product Passport."),
            //     'blog_category_id' => 1,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);
            // #Up to 2025:
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 10,
            //     'name' => Str::slug("Up to 2025: Connecting efforts"),
            //     'blog_category_id' => 2,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);
            // #chile
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 10,
            //     'name' => Str::slug("Chile’s Clothing Dump"),
            //     'blog_category_id' => 1,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);
            // //adidas
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 10,
            //     'name' => Str::slug("Championing Circularity: How To Drive Sustainable Change Inside Out"),
            //     'blog_category_id' => 1,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);
            // //ia
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 10,
            //     'name' => Str::slug("Revolutionizing textiles: How AI is shaping the future of fabric production."),
            //     'blog_category_id' => 2,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);
            // //Consumidor
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 10,
            //     'name' => Str::slug("They key role of consumer behavior in the textile industry"),
            //     'blog_category_id' => 2,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);
            // //Industry 4.0
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 10,
            //     'name' => Str::slug("Industry 4.0 in the Textile Industry: Revolutionizing Production with Smart Technology"),
            //     'blog_category_id' => 1,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);

            #crafting the Perfect Fit  id: 12
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 10,
            //     'name' => Str::slug("Crafting the Perfect Fit: The Role of Customization in the Textile Industry"),
            //     'blog_category_id' => 1,
            //     'division_id' => 1,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);

            // #The Athleisure Revolution:  id: 13
            // DB::table('blogs')->insert([
            //     'video' => "",
            //     // 'main_image' => 10,
            //     'name' => Str::slug("The Athleisure Revolution: Redefining Fashion and Its Impact on the Textile Industry"),
            //     'blog_category_id' => 1,
            //     'division_id' => 1,
            //     'created_at' => now(),
            // ]);

            #Sustainable
            DB::table('blogs')->insert([
                'video' => "",
                // 'main_image' => 10,
                'name' => Str::slug("Sustainable Fabrics 101: Understanding and Exploring the 5 Most Popular Ones"),
                'blog_category_id' => 1,
                'division_id' => 1,
                'created_at' => now(),
            ]);

        }
    }
}
