<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gallery_blog_images', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('name image');
            $table->foreignId('blog_id')->default(2)->constrained()->onDelete('cascade')->comment('Foreing Id table blogs');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gallery_blog_images');
    }
};
