<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('catalogue_contacts', function (Blueprint $table) {
            $table->id();
            $table->string('email', 100)->comment('Contact E-Mail');;
            $table->string('name', 100)->comment('Full name');
            $table->string('country', 100)->comment('Contry');
            $table->string('product_type', 100)->comment('Type product : Machinery or Product');
            $table->string('product_name', 100)->comment('Name product');
            $table->foreignId('division_id')->constrained()->onDelete('cascade')->comment('Foreing Id table divisions');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('catalogue_contacts');
    }
};
