<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        Schema::disableForeignKeyConstraints();


        Schema::dropIfExists('product_category_translations');
        Schema::dropIfExists('product_categories');
        Schema::dropIfExists('product_translations');
        Schema::dropIfExists('products');
        Schema::dropIfExists('product_images');
        Schema::dropIfExists('product_divisions');


    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //

        Schema::disableForeignKeyConstraints();

        Schema::create('product_category_translations', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100)->comment('Name of category product');
            $table->text('description')->comment('Description of category product');
            $table->foreignId('product_category_id')->constrained()->onDelete('cascade')->comment('Foreing Id table product_categories');
            $table->foreignId('language_id')->constrained()->onDelete('cascade')->comment('Foreing Id table languages');
            $table->timestamps();
        });

        Schema::create('product_categories', function (Blueprint $table) {
            $table->id();
            $table->string('image')->comment('Image of product category');
            $table->foreignId('product_sector_id')->constrained()->onDelete('cascade')->comment('Foreing Id table product_sectors');
            $table->timestamps();
        });

        Schema::create('product_translations', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100)->comment('Name of product');
            $table->text('description')->comment('Description of product');
            $table->foreignId('product_id')->constrained()->onDelete('cascade')->comment('Foreing Id table products');
            $table->foreignId('language_id')->constrained()->onDelete('cascade')->comment('Foreing Id table languages');
            $table->timestamps();
        });

        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->integer('main_image')->comment('Main image of product');
            $table->foreignId('product_category_id')->constrained()->onDelete('cascade')->comment('Foreing Id table product_categories');
            $table->timestamps();
        });

        Schema::create('product_images', function (Blueprint $table) {
            $table->id();
            $table->string('image')->comment('Image of product');
            $table->foreignId('product_id')->constrained()->onDelete('cascade')->comment('Foreing Id table products');
            $table->timestamps();
        });

        Schema::create('product_divisions', function (Blueprint $table) {
            $table->id();
            $table->integer('quantity')->comment('Quantity of product');
            $table->foreignId('division_id')->constrained()->onDelete('cascade')->comment('Foreing Id table divisions');
            $table->foreignId('product_id')->constrained()->onDelete('cascade')->comment('Foreing Id table products');
            $table->timestamps();
        });


    }
};
