<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('machine_category_translations', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100)->comment('Machine category name');
            $table->foreignId('machine_category_id')->constrained()->onDelete('cascade')->comment('Foreing Id table machine_categories');
            $table->foreignId('language_id')->constrained()->onDelete('cascade')->comment('Foreing Id table languages');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('machine_category_translations');
    }
};
