<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('logos', function (Blueprint $table) {
            $table->id()->comment('Id');
            $table->string('url_logo')->comment('Division logo url');
            $table->string('url_logo_small')->comment('Division small logo url');
            $table->string('url_logo_short')->comment('Division short logo url');
            $table->string('url_logo_short_small')->comment('Division short y small logo url');
            $table->string('url_logo_white')->comment('Division white logo url');
            $table->foreignId('division_id')->constrained()->onDelete('cascade')->comment('Foreing Id table divisions');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('logos');
    }
};
