<?php


namespace App\Utils;

class ProductsUtil
{

    public $weaving;
    public $knitting;
    public $braiding;
    public $popularProductsHome;
    public $general;
    public $repre;
    public $productWeavingList;
    public $productKnittingList;
    public $productBraidingList;

    public function __construct()
    {
        // Inicializar las propiedades con los datos
        $this->weaving            = $this->getProductWeaving();
        $this->knitting           = $this->getProductKnitting();
        $this->braiding           = $this->getProductBraiding();
        $this->general            = $this->getProductGeneral();
        $this->repre              = $this->getRepre();
        $this->productWeavingList = $this->getProductWeavingList();
        $this->productKnittingList = $this->getProductKnittingList();
        $this->productBraidingList = $this->getProductBraidingList();
    }

    public static function convertArrayToObject(array $array)
    {
        return json_decode(json_encode($array));
    }

    public static function getRepre()
    {
        $data = [
            [
                'name' => "brasil",
                'img' =>  "images/products/Logo Kern Liebers.png",
                'description' => "kern"
            ],
            [
                'name' => "colombia",
                'img' => "images/products/Logo Henghui.png",
                'description' => "hengui"
            ],
            [
                'name' => "mexico",
                'img' => "images/products/Logo Henghui.png",
                'description' => "hengui"

            ]
        ];

        return  collect(self::convertArrayToObject($data));
    }


    public static function getProductWeavingList()
    {
        $data = [
            "weaving-list1",
            "weaving-list2",
            "weaving-list3",
            "weaving-list4",
            "weaving-list5",
            "weaving-list6",
        ];

        return  collect(self::convertArrayToObject($data));
    }

    public static function getProductKnittingList()
    {
        $data = [
            "knitting-list1",
            "knitting-list2",
            "knitting-list3",
            "knitting-list4",
            "knitting-list5",
        ];

        return  collect(self::convertArrayToObject($data));
    }


    public static function getProductBraidingList()
    {
        $data = [
            "braiding-list1",
            "braiding-list2",
        ];

        return  collect(self::convertArrayToObject($data));
    }

    public static function getProductWeaving()
    {
        $data = [
            [
                'name' => "title-rapier-translation",
                'description' => "description-rapier-translation",
                'images' => [
                    'Blade' => [
                        'key_translation' => "prod-Blade-for-Edc",
                        'image' => "images/products/Weaving/Rapier/BLADE FOR E.D.C.png"
                    ],
                    'gripper' => [
                        'key_translation' => "prod-enter-gripper",
                        'image' =>   "images/products/Weaving/Rapier/ENTER GRIPPER.png",
                    ],
                    'guide' => [
                        'key_translation' => "prod-Guide-Hook",
                        'image' =>  "images/products/Weaving/Rapier/GUIDE HOOK.png",
                    ],
                    'lateral' => [
                        'key_translation' => "prod-Lateral-bar",
                        'image' => "images/products/Weaving/Rapier/LATERAL BAR.png",
                    ],
                    'oil' => [
                        'key_translation' => "prod-Oil-filter",
                        'image' =>   "images/products/Weaving/Rapier/OIL FILTER.png",
                    ],
                    'sporcket' => [
                        'key_translation' => "prod-Sprocket-wheel",
                        'image' => "images/products/Weaving/Rapier/SPROCKET WHEEL.png",
                    ],
                ]
            ],
            [
                'name' => "title-air-translation",
                'description' => "description-air-translation",
                'images' => [

                    'display' => [
                        'key_translation' => "prod-Display",
                        'image' => "images/products/Weaving/Air loom/DISPLAY.png",
                    ],
                    'leno' => [
                        'key_translation' => "prod-Leno-motor",
                        'image' => "images/products/Weaving/Air loom/LENO MOTOR.png",
                    ],
                    'piston' => [
                        'key_translation' => "prod-Piston-assy",
                        'image' => "images/products/Weaving/Air loom/PISTON-ASSY.png",
                    ],
                    'rhbobbin' => [
                        'key_translation' => "prod-RH-bobbin",
                        'image' => "images/products/Weaving/Air loom/RH BOBBIN.png",
                    ],
                    'solenid' => [
                        'key_translation' => "prod-Solenoid-toy",
                        'image' => "images/products/Weaving/Air loom/SOLENOID TOY.png",
                    ],
                    'submozzle' => [
                        'key_translation' => "prod-Sub-nozzle",
                        'image' => "images/products/Weaving/Air loom/SUB NOZZLE.png",
                    ],
                ]
            ],
            [
                'name' => "title-projectile-translation",
                'description' => "description-projectile-translation",
                'images' => [

                    'brake' => [
                        'key_translation' => "prod-Brake-lining",
                        'image' => "images/products/Weaving/Proyectile loom/BRAKE LINING.png",
                    ],
                    'guide' => [
                        'key_translation' => "prod-Guide-tooth-D1",
                        'image' =>  "images/products/Weaving/Proyectile loom/GUIDE TOOTH D1.png",
                    ],
                    'picking' => [
                        'key_translation' => "prod-Picking-link",
                        'image' =>  "images/products/Weaving/Proyectile loom/PICKING LINK.png",
                    ],
                    'pickingshoe' => [
                        'key_translation' => "prod-Picking-shoe",
                        'image' => "images/products/Weaving/Proyectile loom/PICKING SHOE.png",
                    ],
                    'projectile' => [
                        'key_translation' => "prod-Projectile",
                        'image' =>  "images/products/Weaving/Proyectile loom/PROJECTILE.png",
                    ],
                    'projectile2' => [
                        'key_translation' => "prod-Projectile",
                        'image' =>  "images/products/Weaving/Proyectile loom/PROJECTILE-2.png",
                    ],
                    'selvedge' => [
                        'key_translation' => "prod-Selvedge-gripper",
                        'image' =>   "images/products/Weaving/Proyectile loom/SELVEDGE GRIPPER.png",
                    ],

                ]
            ],
            [
                'name' => "title-jacquard-translation",
                'description' => "description-jacquard-translation",
                'images' => [

                    'slector' => [
                        'key_translation' => "prod-Block-selector",
                        'image' =>   "images/products/Weaving/Jacquard/BLOCK SELECTOR.png",
                    ],
                    'calbem6' => [
                        'key_translation' => "prod-Cable-M6",
                        'image' =>    "images/products/Weaving/Jacquard/CABLE M6 16.png",
                    ],
                    'connectionpu' => [
                        'key_translation' => "prod-Connection-pulley",
                        'image' =>   "images/products/Weaving/Jacquard/CONNECTION PULLEY.png",
                    ],
                    'displayj6' => [
                        'key_translation' => "prod-Display",
                        'image' =>   "images/products/Weaving/Jacquard/DISPLAY JC6.png",
                    ],
                    'linklever' => [
                        'key_translation' => "prod-Link-lever",
                        'image' =>   "images/products/Weaving/Jacquard/LINK LEVER.png",
                    ],
                    'staubli' => [
                        'key_translation' => "prod-Staubli-main-dobby-kit",
                        'image' =>   "images/products/Weaving/Jacquard/STAUBLI MAIN DOBBY KIT.png",
                    ],
                    'jacquard' => [
                        'key_translation' => "prod-Staubli-module",
                        'image' =>   "images/products/Weaving/Jacquard/STAUBLI MODULE.png"
                    ],

                ]
            ],
            [
                'name' => "title-general-translation",
                'description' => "description-general-translation",
                'images' => [
                    'bake' => [
                        'key_translation' => "prod-Brake-IRO",
                        'image' =>    "images/products/Weaving/General Spare parts/BRAKE IRO.png",
                    ],
                    'brakelg' => [
                        'key_translation' => "prod-Brake-LGL",
                        'image' =>   "images/products/Weaving/General Spare parts/BRAKE LGL.png",
                    ],
                    'healds' => [
                        'key_translation' => "prod-Healds-SIM",
                        'image' =>    "images/products/Weaving/General Spare parts/HEALDS SIM.png",
                    ],
                    'lateral' => [
                        'key_translation' => "prod-Lateral-bar",
                        'image' =>    "images/products/Weaving/General Spare parts/LATERAL BAR.png",
                    ],
                    'leno' => [
                        'key_translation' => "prod-Leno-device",
                        'image' =>   "images/products/Weaving/General Spare parts/LENO DEVICES.png",
                    ],
                    'stabli' => [
                        'key_translation' => "prod-Staubli-module",
                        'image' =>    "images/products/Weaving/General Spare parts/STAUBLI MODULE.png",
                    ],
                    'tie' => [
                        'key_translation' => "prod-Tie-rod",
                        'image' =>  "images/products/Weaving/General Spare parts/TIE ROD.png",
                    ],
                    'warp' => [
                        'key_translation' => "prod-Warp-stop-bar-toy",
                        'image' =>    "images/products/Weaving/General Spare parts/WARP STOP BAR TOY.png"
                    ],
                ]
            ]

        ];

        return  collect(self::convertArrayToObject($data));
    }


    public static function getProductKnitting()
    {
        $data = [
            [
                'name' => "title-circular-translation",
                'description' => "description-circular-translation",
                'images' => [
                    'cilinders' => [
                        'key_translation' => "prod-Cilinders-and-tensioners",
                        'image' =>   "images/products/Knitting/Circular machine/Cilinders and Tensioners.png",
                    ],
                    'needles' => [
                        'key_translation' => "prod-Needles-and-sinkers",
                        'image' =>  "images/products/Knitting/Circular machine/Needles and Sinkers.png",
                    ],
                    'yarn' => [
                        'key_translation' => "prod-yarn-feeders",
                        'image' =>  "images/products/Knitting/Circular machine/Yarn Feeders.png",
                    ],
                ]
            ],
            [
                'name' => "title-flat-translation",
                'description' => "description-flat-translation",
                'images' => [
                    // "images/resource/products/1.png",
                    // "images/resource/products/1.png",
                    // "images/resource/products/1.png",
                ]
            ],
            [
                'name' => "title-warp-translation",
                'description' => "description-warp-translation",
                'images' => [
                    'board' => [
                        'key_translation' => "prod-Board-for-electronic",
                        'image' =>   "images/products/Knitting/Warp Knitting/BOARD FOR ELECTRONIC.png",
                    ],
                    'bus' => [
                        'key_translation' => "prod-Bus-cable",
                        'image' =>    "images/products/Knitting/Warp Knitting/BUS CABLE.png",
                    ],
                    'yarn' => [
                        'key_translation' => "prod-Yarn-guide",
                        'image' =>  "images/products/Knitting/Warp Knitting/YARN GUIDE.png",
                    ],
                    'yarn-sensor' => [
                        'key_translation' => "prod-Yarn-sensor",
                        'image' => "images/products/Knitting/Warp Knitting/YARN SENSOR.png",
                    ],
                ]
            ],
            [
                'name' => "title-socks-translation",
                'description' => "description-socks-translation",
                'images' => [
                    // "images/resource/products/1.png",
                    // "images/resource/products/1.png",
                    // "images/resource/products/1.png",
                ]
            ],
            [
                'name' => "title-general-spareparts-translation",
                'description' => "description-general-spareparts-translation",
                'images' => [
                    'grease' => [
                        'key_translation' => "prod-Grease",
                        'image' =>   "images/products/Knitting/General parts/Grease.png",
                    ],
                    'tipping' => [
                        'key_translation' => "prod-Tipping-film",
                        'image' =>    "images/products/Knitting/General parts/Tipping film.png",
                    ],
                    'yarn-nylo' => [
                        'key_translation' => "prod-Yarn-nylon",
                        'image' =>   "images/products/Knitting/General parts/Yarn - Nylon.png",
                    ],
                ]
            ],
        ];

        return  collect(self::convertArrayToObject($data));
    }


    public static function getProductBraiding()
    {
        $data = [
            [
                'name' => "title-braiding-machine-translation",
                'description' => "description-braiding-machine-translation",
                'images' => [
                    'carriers' => [
                        'key_translation' => "",
                        'image' =>  "images/products/Braiding/Carriers.png",
                    ],
                    'dial' => [
                        'key_translation' => "",
                        'image' =>  "images/products/Braiding/Dial Gear.png",
                    ],
                    'flange' => [
                        'key_translation' => "",
                        'image' =>  "images/products/Braiding/Flange head.png",
                    ],
                ]
            ],
            [
                'name' => "title-braiding-accessories-translation",
                'description' => "description-braiding-accessories-translation",
                'images' => [
                    'lurex' => [
                        'key_translation' => "",
                        'image' =>   "images/products/Braiding/Lurex Yarn.png",
                    ],
                    'tippping' => [
                        'key_translation' => "",
                        'image' =>  "images/products/Braiding/Printed Tipping Film.png",
                    ],
                    'tipping-film' => [
                        'key_translation' => "",
                        'image' =>  "images/products/Braiding/Tipping Film.png",
                    ],
                ]
            ],
        ];

        return  collect(self::convertArrayToObject($data));
    }

    public static function getProductGeneral()
    {
        $data = [
            [
                'name' => "title-general-eqipment-translation",
                'description' => "description-general-equipment-translation",
                'images' => [
                    'auricular' => [
                        'key_translation' => "prod-Auricular-plug-headset",
                        'image' =>   "images/products/General equipment/AURICULAR PLUG-HEADSET.png",
                    ],
                    'century' => [
                        'key_translation' => "prod-Century-tex",
                        'image' =>  "images/products/General equipment/CENTURY TEX..png",
                    ],
                    'circular' => [
                        'key_translation' => "prod-Circular-cutting",
                        'image' =>  "images/products/General equipment/CIRCULAR CUTTING.png",
                    ],
                    'conting' => [
                        'key_translation' => "prod-Counting-lens",
                        'image' =>  "images/products/General equipment/COUNTING LENS.png",
                    ],
                    'curve' => [
                        'key_translation' => "prod-Curve-metal",
                        'image' =>  "images/products/General equipment/CURVE METAL.png",
                    ],
                    'dalo' => [
                        'key_translation' => "prod-Dalo-tex",
                        'image' =>  "images/products/General equipment/DALO TEX..png",
                    ],
                    'electric' => [
                        'key_translation' => "prod-Electric-cutter",
                        'image' =>  "images/products/General equipment/ELECTRIC CUTTER.png",
                    ],
                    'humidifier' => [
                        'key_translation' => "prod-Humidifier-device",
                        'image' =>   "images/products/General equipment/HUMIDIFIER DEVICE.png",
                    ],
                    'mat' => [
                        'key_translation' => "prod-Mat-to-cut",
                        'image' =>  "images/products/General equipment/MAT TO CUT.png",
                    ],
                    'rechargeable' => [
                        'key_translation' => "prod-Rechargeable-electric",
                        'image' =>   "images/products/General equipment/RECHARGEABLE ELECTRIC.png",
                    ],
                    'roll' => [
                        'key_translation' => "prod-Roll-cutter",
                        'image' =>  "images/products/General equipment/ROLL-CUTTER.png",
                    ],
                    'sicssors' => [
                        'key_translation' => "prod-Scissor",
                        'image' =>   "images/products/General equipment/SCISSORS.png",
                    ],
                    'stain' => [
                        'key_translation' => "prod-Stain-remover",
                        'image' =>   "images/products/General equipment/STAIN REMOVER.png",
                    ],
                    'standard' => [
                        'key_translation' => "prod-Standard-blade",
                        'image' =>  "images/products/General equipment/STANDARD BLADE.png",
                    ],
                    'tessilsolv' => [
                        'key_translation' => "prod-Tessilsolv",
                        'image' =>  "images/products/General equipment/TESSILSOLV.png",
                    ],
                    'uhueasy' => [
                        'key_translation' => "prod-Uhu-easy-glue",
                        'image' =>  "images/products/General equipment/UHU EASY GLUE.png"
                    ],
                ]
            ],
            [
                'name' => "title-troley-translation",
                'description' => "description-troley-translation",
                'images' => [
                    'group302' => [
                        'key_translation' => "prod-troleys",
                        'image' =>  "images/products/General equipment/troleys/Group 302.png",
                    ],
                    'group297' => [
                        'key_translation' => "prod-troleys",
                        'image' =>  "images/products/General equipment/troleys/Group 297.png",
                    ],
                    'group303' => [
                        'key_translation' => "prod-troleys",
                        'image' =>     "images/products/General equipment/troleys/Group 303.png"
                    ],
                ]
            ],
        ];

        return  collect(self::convertArrayToObject($data));
    }
}
