<?php

namespace App\Utils;

use App\Utils\KeywordsUtil;
use Illuminate\Support\Facades\Route;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\OpenGraph;

class DataPageUtil
{

    public  function dataPage($info = null)
    {
        #get the subdomain
        $subdomain = session('subdomain');
        #get info Division
        $division =  session('division');
        $namePage = Route::currentRouteName();

        #get SEO
        $seoData = SeoUtil::getSeoData($subdomain, $info);

        $division->id == 1 ? SEOMeta::setTitle($seoData['data'][$namePage]['title']) : SEOMeta::setTitle($seoData['data'][$namePage]['title'] . " | " . __("nationality.c-".$division->name));
        SEOMeta::setDescription($seoData['data'][$namePage]['description']);
        SEOMeta::addKeyword($seoData['data'][$namePage]['keyword']);

        SEOMeta::addMeta('google-site-verification', $seoData['contentMeta'], 'name');


        OpenGraph::setDescription('ITG Group, every thread of our international team always at your service.');
        OpenGraph::setTitle('Itg - Group');
        OpenGraph::setUrl(route('home.index'));
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addImage(asset($division->logo->url_logo_small));


        return $division;
    }
}
