<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MachineDetail extends Model
{
    use HasFactory;

        #query to machines (belongsTo)
        public function machine(){
            return $this->belongsTo(Machine::class);
        }
    
            #query to MachineDetailTranslation (hasOne)
        public function translation(){
            $lang  = session('langSet');
            return $this->hasOne(MachineDetailTranslation::class)->where('language_id', $lang->id);
        }
}
