<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Machine extends Model
{
    use HasFactory;


    #query to MachineCategory (belongsTo)
    public function machineCategory()
    {
        return $this->belongsTo(MachineCategory::class);
    }

    #query to MachineImage (hasMany)
    public function machineImages()
    {
        return $this->hasMany(MachineImage::class);
    }

    #query to MachineDetail (hasMany)
    public function machineDetails()
    {
        return $this->hasMany(MachineDetail::class);
    }

    #query to MachineFeature (hasMany)
    public function machineFeatures()
    {
        return $this->hasMany(MachineFeature::class);
    }

    #query to MachineTranslation (hasOne)
    public function translation()
    {
        $lang  = session('langSet');
        return $this->hasOne(MachineTranslation::class)->where('language_id', $lang->id);
    }

        #query to pdf_sector (hasOne)
        public function  cataloguePdf(){
            $lang  = session('langSet');
            return $this->hasOne(MachineCatalogue::class, 'machine_id')->whereIn('language_id', [$lang->id, 2])
            ->orderByRaw("FIELD(language_id, $lang->id, 2)");
        }
}
