<?php

namespace App\Livewire;

use Livewire\Component;
use App\Mail\ContactMailable;
use App\Models\ContactProduct;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;

class ContactProductsPost extends Component
{
    use LivewireAlert;


    public $name;
    public $country;
    public $email;
    public $messageEmail;
    public $dataDivision;


    protected  $rules = [
        'name' => "required|string|max:100",
        'country' =>   "required|string|max:100",
        'email' => 'required|email|max:100',
        'messageEmail' => 'required|string',
    ];
    
    public function render()
    {
        return view('livewire.contact-products-post');
    }
    public function store()
    {
        #validate
        $this->validate();

        //content Email
        $contentEmail = $this->emailContent();
        $title        = "New product contact message";
        $subject      = 'New contact message sent from products';


        try {
            #send email
            Mail::to('info@group-itg.com')
            ->bcc(['ismaharo18@gmail.com', 'luiscastellanos.dv@gmail.com'])
            ->send(new ContactMailable($contentEmail, $title, $subject, $file = null));
            #save information
            ContactProduct::create([
                'name'          => $this->name,
                'country'       => $this->country,
                'email'         => $this->email,
                'message'       => $this->messageEmail,
                'division_id'   => $this->dataDivision->id,
            ]);
            #Clean form
            $this->cleanForm();
            #message success
            $this->alert('success', __('messages.success-email'));
            session()->flash('messageSuccess', __('messages.success-email'));
        } catch (\Exception $e) {
            #message error
            session()->flash('error_message', $e);
            $this->alert('error', __('messages.error-email'));
        }
    }


    public function emailContent()
    {
        //info form email
        $content = '
        
        <h3 style="margin-bottom: 20px;">Hello, '. $this->name  .' saw some of your products and wants to contact you !
        </h3>
        <p><strong>Name: </strong>'. $this->name  .'</p>
        <p><strong>Email: </strong>'. $this->email  .'</p>
        <p><strong>Country: </strong>'. $this->country  .'</p>
        <p><strong>Division visited: </strong>'. $this->dataDivision->name  .'</p>
        <p><strong>Message: </strong></p>
        <p>'. $this->messageEmail  .'</p> 
        ';

        return $content;
    }

    public function cleanForm(){
        $this->name = '';
        $this->country = '';
        $this->email = '';
        $this->messageEmail = '';
    }
}
